/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.packets.components.APacketBase;

public class PacketEntityBulletHitExternalEntity
extends APacketBase {
    private final UUID gunID;
    private final UUID entityID;
    private final double amount;

    public PacketEntityBulletHitExternalEntity(IWrapperEntity entity, Damage damage) {
        super(null);
        this.gunID = damage.damgeSource.uniqueUUID;
        this.entityID = entity.getID();
        this.amount = damage.amount;
    }

    public PacketEntityBulletHitExternalEntity(ByteBuf buf) {
        super(buf);
        this.gunID = PacketEntityBulletHitExternalEntity.readUUIDFromBuffer(buf);
        this.entityID = PacketEntityBulletHitExternalEntity.readUUIDFromBuffer(buf);
        this.amount = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityBulletHitExternalEntity.writeUUIDToBuffer(this.gunID, buf);
        PacketEntityBulletHitExternalEntity.writeUUIDToBuffer(this.entityID, buf);
        buf.writeDouble(this.amount);
    }

    @Override
    public void handle(AWrapperWorld world) {
        PartGun gun = world.getBulletGun(this.gunID);
        IWrapperEntity entity = world.getExternalEntity(this.entityID);
        if (entity != null) {
            EntityBullet.performExternalEntityHitLogic(entity, new Damage(gun, entity.getBounds(), this.amount));
        }
    }
}

